varying vec2 pos;
varying vec3 RayOrg;
varying vec3 RayDir;
varying vec4 sphere[3];
varying vec4 light1;
varying vec4 light1_color;
varying vec3 box_min[3];
varying vec3 box_max[3];
varying vec3 box_color[3];
varying int numboxes;
uniform int ScreenWidth;
uniform int ScreenHeight;
uniform float time;
uniform sampler2D tex0;

void main()
{
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	pos = (gl_Position.xy+vec2(1,1))/2.0;
	vec3 camera_position=vec3(0,150,-195.0);
	vec3 cam_dir = normalize(vec3(0,0,0)-camera_position);//normalize(vec3(0,-cos(time/2.0)/2.0,1));//normalize(vec3(cos(time/5000.0),0,sin(time/5000.0)));
	vec3 cam_up = normalize(vec3(0,1,0));
	vec3 cam_right = cross(cam_dir,cam_up);
	cam_right = normalize(cam_right);

	cam_up = -cross(cam_dir,cam_right);
	cam_up = normalize(cam_up);

	float FOV = 90.0f;
	float theta = (FOV*3.1415*0.25) / 180.0f;
	float half_width = tan(theta);
	float aspect = (float)ScreenWidth / (float)ScreenHeight;

	float u0 = -half_width * aspect;
	float v0 = -half_width;
	float u1 =  half_width * aspect;
	float v1 =  half_width;
	float dist_to_image = 1;

	vec3 a = (u1-u0)*cam_right;
	vec3 b = (v1-v0)*cam_up;
	vec3 c = camera_position + u0*cam_right + v0*cam_up + cam_dir;

	float xf = (pos.x*ScreenWidth-0.5)/(float)ScreenWidth;
	float yf = (pos.y*ScreenHeight-0.5)/(float)ScreenHeight;;

	vec3 t1 = c+(a*(xf));
	vec3 t2 = b*(yf);
	vec3 image_pos = t1 + t2;
	RayOrg = image_pos;
	RayDir = image_pos-camera_position;
	RayDir = normalize(RayDir);

	light1 = vec4(0,90,0,1);
	light1_color = vec4(1,1,1,5);
	int sn=0;
	
	numboxes=10;
	float mx=0;
	float my=0;
	float mz=30;
	float boxsize=0.2;
	int cc=0;
	
}